/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */


package cs6620.material;

/**
 * A diffuse lambertian material that also emitts light. The emission is
 * diffuse.
 */
public class LambertianEmitter extends Lambertian {
    private RGBColor radiosity;
    
    public LambertianEmitter() {
        radiosity = new RGBColor(0,0,0);
    }
    
    public void setRadiosity(RGBColor inRadiosity) {
        radiosity.set(inRadiosity);
    }
    
    public RGBColor getRadiosity() {
        return radiosity;
    }
    
    public boolean isEmissive() {
        return true;
    }
}
