/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */


package cs6620.material;

import cs6620.material.RGBColor;
import javax.vecmath.Vector3d;

/**
 * A diffuse lambertian material.
 */
public class Lambertian extends Material {
    protected RGBColor rho;
    
    public Lambertian() {
        rho = new RGBColor(0,0,0);
    }
    
    /** Creates a new instance of Lambertian */
    public Lambertian(RGBColor inRho) {
        rho = new RGBColor(inRho);
    }
    
    public RGBColor getRho() {
        return rho;
    }
    
    public void setRho(RGBColor inRho) {
        rho.set(inRho);
    }
    
    public void evaluateBRDF(Vector3d incidentDirection, Vector3d exitantDirection, RGBColor outValue) {
        // To be done
    }
    
    public void evaluateEmission(Vector3d exitantDirection, RGBColor outValue) {
        outValue.set(0,0,0);
    }
    
    public boolean isEmissive() {
        return false;
    }
}
