/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */


package cs6620.material;

import cs6620.material.RGBColor;
import javax.vecmath.Vector3d;

/**
 * A Cook-Torrance material, as specified in the Computer Graphics 1981 paper
 * "A Reflectance Model for Computer Graphics"
 */
public class CookTorrance extends Material {
    private double s;
    private double m;
    private RGBColor n;
    private RGBColor k;
    private RGBColor reflectivity;
    
    public CookTorrance() {
	    n = new RGBColor (0,0,0);
	    k = new RGBColor (0,0,0);
	    reflectivity = new RGBColor (0,0,0);
    }
    
    public void evaluateBRDF(Vector3d incidentDirection, Vector3d exitantDirection, RGBColor outValue) {
    }
    
    public void evaluateEmission(Vector3d exitantDirection, RGBColor outValue) {
        outValue.set(0,0,0);
    }
    
    public boolean isEmissive() {
        return false;
    }
    
    /** Getter for property s.
     * @return Value of property s.
     *
     */
    public double getS() {
        return s;
    }
    
    /** Setter for property s.
     * @param m New value of property s.
     *
     */
    public void setS(double m) {
        this.s = s;
    }
     
    /** Getter for property m.
     * @return Value of property m.
     *
     */
    public double getM() {
        return m;
    }
    
    /** Setter for property m.
     * @param m New value of property m.
     *
     */
    public void setM(double m) {
        this.m = m;
    }
    
    /** Getter for property n.
     * @return Value of property n.
     *
     */
    public RGBColor getN() {
        return n;
    }
    
    /** Setter for property n.
     * @param n New value of property n.
     *
     */
    public void setN(RGBColor n) {
        this.n.set(n);
    }
    
    /** Getter for property k.
     * @return Value of property k.
     *
     */
    public RGBColor getK() {
        return k;
    }
    
    /** Setter for property k.
     * @param k New value of property k.
     *
     */
    public void setK(RGBColor k) {
        this.k.set(k);
    }
 
    /** Getter for property reflectivity.
     * @return Value of property reflectivity.
     *
     */
    public RGBColor getReflectivity() {
        return reflectivity;
    }
    
    /** Setter for property reflectivity.
     * @param n New value of property reflectivity.
     *
     */
    public void setReflectivity(RGBColor reflectivity) {
        this.reflectivity.set(reflectivity);
    }
        
}
