/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */


package cs6620.geometry;

import cs6620.primitive.Primitive;
import javax.vecmath.*;

/**
 * The information recorded when a {@link Ray} intersects a {@link Primitive}.
 * This class should be treated as a structure (all fields are public). The
 * fields themselves should not be changed (other than Primitive). Instead,
 * set methods should be called on the fields to change their values. For this
 * reason, never maintain a reference to a field in an intersection record,
 * since its value may change.
 * @author spf +latest $Author: kb $
 * @version $Revision: 1.6 $
 */
public class IntersectionRecord  {
    
    /**
     * The parameter along the ray where the intersection happened.
     */
    public double t = 0.0;
    
    /**
     * The primitive containing this position.  Can be null if position was
     * generated by a non-primitive.  This field is set to be transient to
     * prevent the accidental serialization of the entire scene graph.
     * Geometry id's should be used instead for serialization in most cases.
     */
    public Primitive primitive = null;
    
    /**
     * The primitive uvw coordinates of the surface point.  The meaning and
     * definition of these coordinates depends on the primitive.  You should
     * always check the type of the primitive before trying to interpret or
     * use these coordinates.
     */
    public final Vector2d primitiveUV = new Vector2d();
    
    /**
     * An orthonormal frame whose origin is at the surface point and whose
     * Z-axis is orthogonal to the (geometric) surface.
     */
    public final Frame frame = new Frame();
    
    /**
     * Copies an existing IntersectionRecord.
     * @param inRecord the record to copy
     */
    public void set(IntersectionRecord inRecord) {
        primitive = inRecord.primitive;
        primitiveUV.set(inRecord.primitiveUV);
        frame.set(inRecord.frame);
        t = inRecord.t;
    }
    
    /**
     * Simple access method for frame.origin which may help in code clarity
     */
    public final Vector3d getPosition() {
        return frame.origin;
    }
}
