/*
 * Copyright Kavita Bala, CS 6620, Cornell University
 * Contact kb@cs.cornell.edu
 */


package cs6620;

import cs6620.geometry.IntersectionRecord;
import cs6620.geometry.Ray;
import cs6620.io.Parser;
import cs6620.io.RGBColorImage;
import cs6620.material.RGBColor;
import cs6620.primitive.Primitive;
import cs6620.scene.Camera;
import cs6620.scene.Scene;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import cs6620.material.CookTorrance;

public class RayTracer {
    
    public static void main(String []args) throws ParserConfigurationException, SAXException, IOException {
        Parser parser = new Parser();
        for (int i = 0; i < args.length; i++) {
            String taskFilename = args[i];
            RenderingTask task = (RenderingTask)parser.parse(taskFilename,RenderingTask.class);
            RGBColorImage image = task.getImage();
            Camera camera = task.getCamera();
            Scene scene = task.getScene();
            render(scene,camera,image);
            // The generated image filename is simply the original filename
            // with the suffix replaced by png
            String imageFilename = taskFilename.replaceFirst("\\..*$", ".png");
            try {
                image.save(imageFilename);
            }
            catch (IOException e) {
                System.out.println("Error saving file:"+e);
            }
        }
    }
    
    public static void render(Scene scene, Camera camera, RGBColorImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        RGBColor [] pixels = image.getPixels();
        Ray ray = new Ray();
        scene.convertCompoundObjectsToPrimitives();
        List primitives = scene.getPrimitives();
        List emitters = scene.getPrimitiveEmitters();
        IntersectionRecord record = new IntersectionRecord();
        RGBColor white = new RGBColor(1, 1, 1);
        RGBColor black = new RGBColor(0, 0, 0);
	System.out.println ("Rendering");
        for (int i = 0; i < h; i++) {
            double y = (i+0.5)/h;
            for (int j = 0; j < w; j++) {
                double x = (j+0.5)/w;
                int currentPixelIndex = i*w+j;
                RGBColor currentPixel = pixels[currentPixelIndex];
                camera.getNormalizedRay(x, y, ray);
                boolean intersected = false;
                for (Iterator k = primitives.iterator(); k.hasNext() && !intersected;) {
                    Primitive p = (Primitive)k.next();
                    if (p.intersects(ray,record)) {
                        intersected = true;
                    }
                }
                if (intersected) {
                    currentPixel.set(white);
                } else {
                    currentPixel.set(black);
                }
            }
        }
    }
}
