import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

/** tracker connection handler */
public class TrackerConnection {
	private int localport;
	private byte[] localaddr; //could be IPv4 or IPv6
	public TorrentFile tf;
	
	public TrackerConnection(int localport,byte[] localaddr,String filename){
		this.localport= localport;
		this.localaddr= localaddr;
		parseTorrent(filename);
	}
	
	/** parse torrent file */
	public void parseTorrent(String torrentFile){
	  TorrentFileHandler tfh= new TorrentFileHandler();
	  TorrentFile tf= tfh.openTorrentFile(torrentFile);

	  //initialize some additional TorrentFile info 
	  int nPiece= (tf.file_length/tf.piece_length);
	  if(tf.piece_length*nPiece < tf.file_length){
		  nPiece++;
	  }
	  tf.nPiece= nPiece;
	  tf.avail= new int[nPiece];
	  
	  this.tf= tf;
	}

	/**
	 * scrape tracker
	 */
	public byte[] scrapeTracker() throws Exception{
	  byte[] messageBytes= null;
	  URL scrapeUrl= null;
	  try{
		  String get= "?info_hash="+tf.info_hash_as_url;
  		  //System.out.println("tf.tracker_url_scrape: "+tf.tracker_url_scrape);
  		  scrapeUrl= new URL(tf.tracker_url_scrape+get); //scrape
  	  }
  	  catch(MalformedURLException mue){
  		  mue.printStackTrace();
  	  }
  	  URLConnection uc= scrapeUrl.openConnection();
  	  uc.connect();
  		  
  	  //get response
  	  InputStream is= uc.getInputStream();
			
  	  ByteArrayOutputStream baos= new ByteArrayOutputStream();
  	  byte buf[] = new byte[3072];
  	  int read= 0;
  	  int offset= 0;
  	  while((read= is.read(buf)) != -1){ //need while although it is blocking (fragments)
  		  baos.write(buf,offset,read);
  		  offset+= read;
  	  }
  	  //System.out.println("Reached the end-of-stream of Tracker Reply");
		  
  	  messageBytes= baos.toByteArray();
  	  is.close(); //close InputStream
  	  baos.close(); //close ByteArrayOuputStream
		  
  	  // strip off headers (if necessary)
  	  byte delimiter[]= Helper.getBytes("\r\n");
  	  boolean found= false;
  	  for(int i= 0; !found&&i<messageBytes.length -2; i++){
  		  if((messageBytes[i]==delimiter[0])&&(messageBytes[i+1]==delimiter[1])){
  			  System.out.println("found newline");
  			  found= true;
  			  byte temp[]= new byte[messageBytes.length-i-delimiter.length];
  			  System.arraycopy(messageBytes,i+2,temp,0,temp.length);
  			  messageBytes=temp;
  		  }
  	  }
  	  /*
  	  String msgString = new String(messageBytes,Helper.encoding);
  	  System.out.println(msgString);
  	  */
  	  
  	  String msg= new String(messageBytes,Helper.encoding);
  	  int idx_seed= msg.indexOf("completei");
  	  int idx_seed_end= msg.indexOf("e",idx_seed+9);
  	  int idx_leech= msg.indexOf("incompletei");
  	  int idx_leech_end= msg.indexOf("eeee",idx_leech+11);
  	  
  	  tf.seed=Integer.parseInt(msg.substring(idx_seed+9,idx_seed_end));
  	  tf.leech=Integer.parseInt(msg.substring(idx_leech+11,idx_leech_end));
  	  
  	  return messageBytes;
  }
  
  /** 
   * connect using URL; for the following HTTP GET request 
   * @return tracker response in bytes 
   */ 
  public byte[] connectTracker() { 
	  String rid_url= Helper.byteArrayToURLString(TorrentCrawler.rid); //HTTP escaped rid

	  byte[] messageBytes= null;
	  String get= "?info_hash="+tf.info_hash_as_url;
	  get += "&peer_id="+rid_url;
	  get+= "&port="+localport;
  	  get+= "&uploaded=2415&downloaded="+tf.file_length+"&left=0"; //some of the file is downloaded
  	  //get+= "&event=started"; //first request must have this
  	  get+= "&numwant=2000"; //(optional) default is 50 
  	  URL trackerUrl= null;
  	  try{
  		  //System.out.println("tf.tracker_url: "+tf.tracker_url+get);
  		  trackerUrl= new URL(tf.tracker_url+get);
  	  }
  	  catch(MalformedURLException mue){
  		  mue.printStackTrace();
  	  }
  	  try{
		  URLConnection uc= trackerUrl.openConnection();
		  uc.connect();
		  
		  //print HTTP connection status
		  //System.out.println("HTTP/ "+((HttpURLConnection) uc).getResponseCode() +" "
	        //      + ((HttpURLConnection)uc).getResponseMessage());
	
		  //get response
		  InputStream is= uc.getInputStream();
			
		  ByteArrayOutputStream baos= new ByteArrayOutputStream();
		  byte buf[] = new byte[3072];
		  int read= 0;
		  int offset= 0;
		  while((read= is.read(buf)) != -1){ //need while although it is blocking (fragments)
			  baos.write(buf,offset,read);
			  offset+= read;
		  }
		  //System.out.println("Reached the end-of-stream of Tracker Reply");
		  
		  messageBytes= baos.toByteArray();
		  is.close(); //close InputStream
		  baos.close(); //close ByteArrayOuputStream
		  
		  // strip off headers (if necessary)
		  byte delimiter[]= Helper.getBytes("\r\n");
		  boolean found= false;
		  for(int i= 0; !found&&i<messageBytes.length -2; i++){
			  if((messageBytes[i]==delimiter[0])&&(messageBytes[i+1]==delimiter[1])){
				  System.out.println("found newline");
				  found= true;
				  byte temp[]= new byte[messageBytes.length-i-delimiter.length];
				  System.arraycopy(messageBytes,i+2,temp,0,temp.length);
				  messageBytes=temp;
			  }
		  }
		  
		  scrapeTracker();
  	  }//try
  	  catch(IOException ie){
  		  //ie.printStackTrace();
  		  //System.out.println("Tracker has refused connection from this host. Trying again later...");
  		  return null;
  	  }
  	  catch(Exception e){
  		  e.printStackTrace();
  		  System.exit(1);
  	  }
	  return messageBytes;
  }
}
