import java.net.*;
import java.nio.channels.ServerSocketChannel;
import java.io.*;

/** Torrent Crawler Project 2008-2009
 * burrowed (GNU free licensed): Bencoder, TorrentFile, TorrentFileHandler
 * 
 * This is the main class:
 * @author yeounohchung: Yeounoh Chung (yc336@cornell.edu)
 */
public class TorrentCrawler{
	public static final byte[] rid={1,2,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9,1,2}; //set a 20-byte client ID
	private int localport; //not really used (arbitrary) 
	private byte[] localaddr; //could be IPv4 or IPv6
 
	public ServerSocketChannel tc_server(){
		ServerSocketChannel ssChannel= null;
		boolean bound= false;
		localport= 6881;
		try {
			// Create a non-blocking server socket channel on port 6881-6889
		    ssChannel = ServerSocketChannel.open();
		    ssChannel.configureBlocking(false);
		} 
		catch (IOException ie) {
			System.out.println("server creation failed");
			System.exit(1);
		}
		while(!bound){
			try {
				ssChannel.socket().bind(new InetSocketAddress(localport));
				bound= true;
			}
			catch(IOException ie){
				if(localport == 6889){
					System.out.println("6881-6889 not available for server socket...using port out of range");
				}
				localport++;
				bound= false;
			}
		}
		System.out.println("tc_server bound to "+localport);
		return ssChannel;
	}
	  
	/** 
	 * usage: 
	 */
	public static void main(String[] args){
		int firstArg= 0;
		if(args.length != 2){
			System.out.println("There must be two arguments: 1) total measure time\n" +
					"2) Torrent file name in quotations");
			System.exit(1);
		}
		try {
		    firstArg = Integer.parseInt(args[0]);
		} catch (NumberFormatException e) {
			System.err.println("Argument must be an integer");
			System.exit(1);
		}
		final long measure_period_ms = firstArg;
		
		String filename=args[1]; 
			//"CSI.New.York.S05E02.HDTV.XviD-LOL.avi.4423915.TPB.torrent";
			//"Quantum_Of_Solace_R5_LINE_XviD-COALiTiON__.4588254.TPB.torrent";
			//"Twilight.2008.DvDrip-NoRar__.4752496.TPB.torrent";
		
		TorrentCrawler tc= new TorrentCrawler();
		ServerSocketChannel ssc= tc.tc_server(); //set up a server to accept connections from other peers
		try{
			InetAddress localHost = InetAddress.getLocalHost();
			tc.localaddr= localHost.getAddress();
		}	
		catch(UnknownHostException e){
			e.printStackTrace();
			System.exit(1);
		}
		  
		Logger logger= new Logger();
		logger.init("gen_log","msg_log","con_log");
		TrackerConnection tcn= new TrackerConnection(tc.localport,tc.localaddr,filename);
		MessageQueue msg_q = new MessageQueue(tcn);
		Thread child= new Thread(msg_q);
		child.start();
		PeerConnection pc = new PeerConnection(msg_q,ssc,logger);		
		
		System.out.println("Start");
		pc.connectToNodes(measure_period_ms);
		logger.close();
		
		System.out.println("Store results to S3");
		try{
			S3Disk.LogToS3();
		} catch(Exception e){
			e.printStackTrace();
		}
		System.out.println("The end");
	}
}
