import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;

public class Node {
	private class ListNode{
		public long value;
		public ListNode(long value){
			this.value= value;
		}
	}
	private ArrayList<ListNode> latency_list= new ArrayList<ListNode>();
	private ArrayList<ListNode> downrate_list= new ArrayList<ListNode>();
	public boolean connected;
	public boolean dropped;
	public boolean handshaked;
	public boolean incoming;
	public boolean dr_measured;
	public InetSocketAddress addr;
	public SocketChannel sc;
	public long begin_time; //used for timeout
	public long dr_begin_time; //used for dr measurement
	public ByteBuffer handshake;
	public ByteBuffer readbuf;
	public int readbuf_n= 0;
	public byte[] bf;
	public byte[] bf_init;
	private int retries= 0;
	private final int max_retries = 2;
			
	public Node(InetSocketAddress addr) throws IOException {
		this.addr = addr;
		sc = SocketChannel.open();
		sc.configureBlocking(false);
		handshake= ByteBuffer.allocate(68);
		readbuf= ByteBuffer.allocate(1024);
		readbuf.position(0);
	}
	
	public Node(InetSocketAddress addr,SocketChannel sc) {
		this.addr = addr;
		this.sc = sc;
		handshake= ByteBuffer.allocate(68);
		readbuf= ByteBuffer.allocate(1024);
		readbuf.position(0);
	}
			
	public boolean connectToNode() throws IOException{
		return sc.connect(addr);
	}
		
	public void addBeginTime(long time) {
		begin_time = time;
	}	
	
	public void addDrBeginTime(long time) {
		dr_begin_time = time;
	}
	
	public void addLatency(long time) {
		latency_list.add(new ListNode(time));
	}
	
	public boolean reconnect() {
		try {
			connected= false;
			dropped= true;
			handshaked= false;
			dr_measured= false;
			sc.close();
			if (++retries > max_retries) {
				return false;
			}
			//System.out.println("Reconnecting for node: " + addr);
			sc = SocketChannel.open();
			sc.configureBlocking(false);
		} catch (IOException e) {
			//System.err.println("IOException in reconnect: " + e);
			return false;
		}
		return true;			
	}
	
	public void addDownrate(long dr_end_time,long piece_length){
		if(dr_measured || bf==null || dr_end_time-dr_begin_time <=60000)
			return;
		
		int bf_have_cnt= 0;
		for (int i=0; i<bf.length*8; i++) {
			if(bf_init==null){
				if ((bf[bf.length-i/8-1]&(1<<(i%8))) > 0) {
					bf_have_cnt++;
				}
			}
			else if (((bf[bf.length-i/8-1]&(1<<(i%8)))-
					(bf_init[bf_init.length-i/8-1]&(1<<(i%8)))) > 0) {
				bf_have_cnt++;
			}	
		}
		
		long downrate= (piece_length*bf_have_cnt)/(dr_end_time-dr_begin_time);
		downrate_list.add(new ListNode(downrate));
		dr_measured= true;
	}
	
	public boolean equals(Object in_obj) {
		Node in_node = (Node) in_obj;
		if (in_node.addr.equals(addr)) {
			return true;
		}
		return false;
	}
		
	public int hashCode() {
		return addr.hashCode();
	}		
	
	public String toString() {
		String res= addr.toString();
		res+= " latency:[ ";
		for(int i=0;i<latency_list.size();i++){
			res+= latency_list.get(i).value+" ";
		}
		res+="]";
		
		res+= " downrate:[ ";
		for(int i=0;i<downrate_list.size();i++){
			res+= downrate_list.get(i).value+" ";
		}
		res+="]";
		
		res+= " connected:"+connected;
		res+= " dropped:"+dropped;
		//res+= " extspt:"+extspt;
		res+= " incoming:"+incoming;
		res+= " bf:";
		if(bf==null)
			return res;
		for(int i=0; i<bf.length;i++){
			res+=(short) bf[i]+" ";
		}
		return res;
	}
}