/** monitor */
public class MessageQueue implements Runnable{
	private byte[] queue;
	private int totalPeerNum;
	private boolean finished;
	public TrackerConnection tcn;
	private boolean queue_empty;
	
	public MessageQueue(TrackerConnection tcn){
		this.tcn= tcn;
		queue_empty= true;
	}
	
	public synchronized void finish(){
		notifyAll();
		finished= true;
	}
	
	public synchronized int getTotalPeerNum(){
		return totalPeerNum;
	}
	
	/** reader */
	public synchronized byte[] getQueue(){
		notifyAll();
		if(queue_empty){
			try {
				wait();
			} catch (InterruptedException ie) {
				ie.printStackTrace();
			}
		}
		queue_empty= true;
		return queue;
	}
	
	/**
	 * extract peer addr from tracker resp
	 * @param trackerResp
	 * @return decoded peer list 
	 */
	public synchronized byte[] extract(byte[] trackerResp){
		byte[] peers= null;
		try{
			String msg= new String(trackerResp,Helper.encoding);
			int idx= msg.indexOf(":peers");
			idx= idx+6; //first char after :peers
			
			if(msg.charAt(idx)=='l'){ //dictionary model
				System.out.println("finally we've found an example of dictinary model!");
				System.exit(1);
			}
			else{ //binary model				
				int idx2= msg.indexOf(":",idx); //first : after :peers
				int numbBytes= Integer.parseInt(msg.substring(idx,idx2)); //extract length of string
				totalPeerNum= numbBytes/6;
				int idx3= idx2+1;

				byte[] peerBin= new byte[trackerResp.length-idx3];
				for(int i=idx3;i<trackerResp.length;i++){
					peerBin[i-idx3]= trackerResp[i];
				}
				peers= peerBin;
			}
		}
		catch(Exception e){ //encoding error, etc
			System.out.println("Malformed tracker response");
			//e.printStackTrace();
			return null;
		}
		return peers;
	}
	
	/** writer */
	public synchronized void loop() {
		while(!finished){
			byte[] tracker_resp= tcn.connectTracker();
			if(tracker_resp != null){
				queue = extract(tracker_resp);
				queue_empty= false;
			}
			else{ //connection refused
				queue= null;
			}
			notifyAll();
			try {
				wait();
			} catch (InterruptedException ie) {
				System.err.println("InterruptedException"+ie);
			}
		}
	}		
	
	public void run() {
		loop();
	}
}


