import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashSet;


public class MessageHandler {
	private int bf_size_max;
	private Logger logger;
	
	public MessageHandler(TorrentFile tf,Logger logger){
		bf_size_max = tf.nPiece / 8;
		if(bf_size_max * 8 < tf.nPiece){
			bf_size_max++;
		}
		this.logger= logger;
	}
	
	/**
	 * handles different peer responses
	 * @param sk
	 * @return bit_field in byte[]; null if not available
	 * @throws IOException
	 */
	public byte[] readPeerResponse(Node cur_node,SelectionKey sk,HashSet<Node> peer_set_con){
		SocketChannel sc= cur_node.sc;
		ByteBuffer bb= cur_node.readbuf; //pi's read buf(This design change is important (fr))
		byte[] bf= cur_node.bf;
		int n= 0;
		
		try{
			n= sc.read(bb); //bb's position p+n
		}
		catch(IOException ie){ //remote access closed forcefully
			sk.cancel();						
			if (cur_node.reconnect()) {
				peer_set_con.add(cur_node);								
			}
			return null;
		}
		cur_node.readbuf_n= cur_node.readbuf_n+n;
		
		//decode response (messages)
		bb.position(0);
		while(cur_node.readbuf_n>0){
			bb.position(0);
			byte[] plen= null;
			Byte id= null;
			byte[] payload= null;
			int msglen= 0;
			
			if(cur_node.readbuf_n>=5){ //plen+id
				plen= new byte[4];
				for(int i=0;i<4;i++){
					plen[i]= bb.get();
				}
				id= new Byte(bb.get());
				cur_node.readbuf_n= cur_node.readbuf_n-5;
			}
			else{
				for(int i=0;i<cur_node.readbuf_n;i++)
					bb.get();
				break; //try later after reading more bytes
			}
			
			if((int) plen[0]==19) //handshake
				msglen= 64; //68-4 not 63
			else
				msglen= Helper.uByteIntToInt(plen); //id + payload
			
			//System.out.println(pi.getNBuf()+" elements in buf, msglen-1: "+(msglen-1));
			if(cur_node.readbuf_n>=msglen-1 && msglen>0){ //have payload
				payload= new byte[msglen-1]; //negative array size!
				for(int i=0;i<msglen-1;i++){
					payload[i]= bb.get();
				}
				cur_node.readbuf_n= cur_node.readbuf_n-msglen+1;
			}
			else{
				for(int i=0;i<cur_node.readbuf_n;i++)
					bb.get();
				break;
			}
			//sk.attach(pi);
			//pi= (PeerInfo) sk.attachment();
			
			/*
			InetAddress inet_ident= null;
			int portn_ident= 0;
			try{
				inet_ident= InetAddress.getByAddress(pi.getIP());
				portn_ident= Helper.uByteShortToInt(pi.getPort()); //network order->host
			}
			catch(UnknownHostException uhe){
				uhe.printStackTrace();
			}
			*/
			String ident= cur_node.addr.toString();//"["+inet_ident.getHostAddress()+":"+portn_ident+"]"; //getKey();
			
			logger.writeLine(logger.msg,System.currentTimeMillis(), ident+" msg:"+id);
			//handshake (and bit_field)
			if(id.compareTo(Helper.hs_id)==0){
				//System.out.println("Received handshake");
				if(cur_node.incoming&&!cur_node.handshaked){
					sk.interestOps(SelectionKey.OP_WRITE);
				}
				/*
				if(((short) payload[20] & 0x0010)!=0){ //bit 44
					try{
						if(!pi.getExtKnown()){
							bb_pexHS.position(0);
							sc.write(bb_pexHS); //immediately following handshake, this write shouldn't work??
							pi.setExtKnown(true);
						}
					}
					catch(Exception e){
						System.out.println("write error during PEX handshake");
						e.printStackTrace();
					}
					
					pi.setExtspt(true); //this peer supports ut_pex
					sk.attach(pi);
					pi= (PeerInfo) sk.attachment();
				}
				*/
			}
			//bit field(set to payload since bit field follows handshake immediately)
			else if(id.compareTo(Helper.bf_id)==0){
				bf= payload;
				if(!cur_node.dr_measured){
					cur_node.dr_begin_time= System.currentTimeMillis();
					cur_node.bf_init= bf;
				}
			}
			//have
			else if(id.compareTo(Helper.have_id)==0){
				int pIdx= Helper.uByteIntToInt(payload);
				byte[] bf_temp= new byte[bf_size_max];
				int setbf= 1;
				int RtoLoffset= 7-(pIdx - (pIdx/8)*8); //tricky
				bf_temp[pIdx/8]= (byte) ((setbf << RtoLoffset) & 0xFF);
				
				bf= Helper.bytesOR(bf,bf_temp);
			}
			//extension protocol (not currently in use)
			/*
			else if(false && id.compareTo(Helper.pex_id)==0){
				Bencoder ben= new Bencoder();
				byte[] pex_arr= new byte[payload.length-1];
				System.arraycopy(payload,1,pex_arr,0,payload.length-1);
				HashMap pex_map= ben.unbencodeDictionary(pex_arr);
				Iterator iterator = pex_map.entrySet().iterator();
				
				if(payload[0]==0){ //extension protocol handshake
					//System.out.println("EXP handshake arrived");
					HashMap m_map= null;
					while (iterator.hasNext()){
						Map.Entry me = (Map.Entry) iterator.next();
						if(me.getKey().equals("m")){
							m_map= (HashMap) me.getValue();
							break;
						}
					}
					
					iterator= m_map.entrySet().iterator();
					while(iterator.hasNext()){
						Map.Entry me= (Map.Entry) iterator.next();
						if(me.getKey().equals("ut_pex")){
							pi.setPexType((Integer) me.getValue());
						}
					}
					
					//send pex message
					genPexMsg(pi);
					sc.write(bb_pex);	  
				}
				else{
					System.out.println("PEX message arrived!");
					String msgString = new String(pex_arr,Helper.encoding);
					System.out.print(payload[0]+ " ");
					System.out.println(msgString);
					System.out.println(pex_map);
					if(payload[0]==1){ //pex
						byte[] added= null;
						while (iterator.hasNext()){
							Map.Entry me = (Map.Entry) iterator.next();
							if(me.getKey().equals("added")){
								added= (byte[]) me.getValue();
								System.out.println("added: "+new String(added,Helper.encoding));
								break;
							}
						}
						for(int i=0;i<added.length;i+=6){
							byte[] ip= {added[i],added[i+1],added[i+2],added[i+3]}; 
							byte[] port= {added[i+4],added[i+5]}; //network order
							byte[] key= new byte[6]; //key for PeerMap
							System.arraycopy(ip,0,key,0,4);
							System.arraycopy(port,0,key,4,2);
							String keyStr= Helper.byteArrayToURLString(key);
							
							InetAddress inet= InetAddress.getByAddress(ip);
							int portn= Helper.uByteShortToInt(port); //network order->host
							InetSocketAddress isa= new InetSocketAddress(inet,portn);
							
							SocketChannel sc_pex= null;
							sc_pex = SocketChannel.open();
							sc_pex.configureBlocking(false); //non-blocking I/O
							boolean connected = sc_pex.connect(isa);
							PeerInfo pi_pex= new PeerInfo(sc_pex,ip,port,null,keyStr);
							pi_pex.putHandshake(tf);
							//long timestamp1= System.currentTimeMillis();
							//pi_pex.setStartTime(timestamp1); 
							
							if(connected){
								long timestamp2= System.currentTimeMillis();
								if(mode==1){
									pi_pex.setEndTime(timestamp2);
									pi.storeLatency();
								}
								pi_pex.setConnected(true);
								
								
								//sendHandshake(sc_pex);
								//pi_pex.setHandshaked(true);
								//pi_pex.setStartTime(System.currentTimeMillis());
								
								//sc_pex.register(sel,SelectionKey.OP_READ,pi_pex);
								
								sc_pex.register(sel,SelectionKey.OP_WRITE,pi_pex);
								PeerMap.store(pi_pex.getKey(),pi_pex);
								
								long event_time= timestamp2; //what is this?
							}
							else{
								sc_pex.register(sel,SelectionKey.OP_CONNECT,pi_pex);
							}
						}
					}
				}
			}*/
			bb.compact();
		}//while
		
		return bf;
	}
}
