import java.io.*;
import java.util.HashSet;
import java.util.Iterator;

/**
 * dump peerMap collected PeerInfos onto a .txt file
 * @author yeounohchung
 */
public class Logger{
	private FileWriter fstream1;
	private FileWriter fstream2;
	private FileWriter fstream3;
    public BufferedWriter gen;
    public BufferedWriter msg;
    public BufferedWriter con; 

	public void init(String gen_log,String msg_log,String con_log){
		try{
			fstream1= new FileWriter(gen_log+".txt");
			gen= new BufferedWriter(fstream1);
			fstream2= new FileWriter(msg_log+".txt");
			msg= new BufferedWriter(fstream2);
			fstream3= new FileWriter(con_log+".txt");
			con= new BufferedWriter(fstream3);
		}
		catch(IOException ie){
			ie.printStackTrace();
		}
	}
	
	/* dump peermap to gen_log */
	public void writeAll(TorrentFile tf, HashSet<Node> peer_set){
		try{
			Iterator cur_it= peer_set.iterator();
			while (cur_it.hasNext()) {	
				Node cur_node = (Node)cur_it.next();
				gen.write(cur_node.toString()+"\r\n");
			}
			gen.write("Availability:[ ");
			for(int i=0; i<tf.nPiece;i++){
				tf.avail[i]= getAvailability(i,peer_set);
				gen.write(i+":"+tf.avail[i]+" ");
			}
			gen.write("]\r\n");
			gen.close();
		}
		catch(IOException ie){
			ie.printStackTrace();
		}
	}
	
	public int getAvailability(int piece_index,HashSet<Node> peer_set){
		int offset= piece_index%8;
		int byte_ref= piece_index/8;
		int availability= 0;
		byte[] bf= null;
		
		Iterator cur_it= peer_set.iterator();
		while(cur_it.hasNext()){
			Node cur_node = (Node)cur_it.next();
			bf= cur_node.bf;
			if(bf==null)
				continue;
			if((bf[byte_ref] & (0x00000001<<(7-offset)))!=0)
				availability++;
		}
		
		return availability;
	}
	
	public void writeLine(BufferedWriter out,long event_time,String line){
		try{
			out.write("["+event_time+"] "+line+"\r\n");
		}
		catch(IOException ie){
			ie.printStackTrace();
		}
	}
	
	public void close(){
		try{
			gen.close();
			msg.close();
			con.close();
		}
		catch(IOException ie){
			ie.printStackTrace();
		}
	}
} 


