import java.nio.charset.Charset;
import java.util.*;

/**
 * @author yeounohchung
 * byte encoding from Hunter Payne's code
 */
public class Helper {
	
	public static final String encoding = "US-ASCII";
	private static final Charset asciiSet = Charset.forName(encoding);
	  
	//peer message IDs
	public static final byte hs_id= 'T';
	public static final byte bf_id= 5;
	public static final byte have_id= 4;
	public static final byte ext_id= 9; //obsolete simpleBT extension (not used)
	public static final byte pex_id= (byte) 20; //local information
	public static final byte choke_id= 0;
	public static final byte unchoke_id= 1;
	public static final byte int_id= 2;
	public static final byte unint_id= 3;
	public static final byte req_id= 6;
	public static final byte piece_id= 7;
	public static final byte cancel_id= 8;
	public static final byte port_id= 9;
	  
	/**
	 * bitwise OR operation
	 * functionality very specific to PeerConnector bf merging
	 * @param a byte[] 
	 * @param b byte[]
	 * @return a|b in byte[]
	 */
	public static byte[] bytesOR(byte[] a,byte[] b){
		//in cases of nulls
		if(a==null && b!=null){
			  return b;
		}
		else if(b==null && a!=null){
			return a;
		}	
		else if(a==null && b==null){
			return null;
		}	
		
		//lengths of shorter and longer input arrays
		int long_size= 0;
		int short_size= 0;
		if(a.length >= b.length){
			long_size= a.length;
			short_size= b.length;
		}	
		else{
			long_size= b.length;
			short_size= a.length;
		}
		
		//set return byte[] length to the larger of the lengths(a,b)
		byte[] res= new byte[long_size];
		for(int i=0;i<long_size;i++){
			if(i<short_size){
				int t1= a[i];
				int t2= b[i];
				int or= t1 | t2;
				res[i]= (byte) or;
			}
			else{
				if(a.length > b.length)
					res[i]= a[i];
				else
					res[i]= b[i];
			}
		}
		return res;
	}
	  
	/**
	 * compare a, b
	 * @param a byte[]
	 * @param b byte[]
	 * @param offa beginning index of comparison for a
	 * @param offb beginning index of comparison for b 
	 * @param length number of elements from each offset for comparison
	 * @return true if all elements (offb,offb+length) equal
	 */
	public static boolean compareBytes(byte[] a,int offa,byte[] b,int offb,int length){
		for(int i=0;i<length;i++){
			if((new Byte(a[offa+i]).compareTo(b[offb+i]))!=0)
				return false;			
		}
		return true;
	}

	/**
	 * Converts a string to a byte array using a default character encoding
	 */
	public static byte[] getBytes(String str){
		try {
			return str.getBytes("US-ASCII");
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	} 
	  
	/**
	 * printing of .torrent file description
	 * @param tf
	 */
	public static void testTorrentFile(TorrentFile tf){
		//description of .torrent (shar-1)
		if (tf != null)
		{
			System.out.println("Tracker URL: " + tf.tracker_url);
			System.out.println("File Size (Bytes): " + tf.file_length);
			System.out.println("Piece Size (Bytes): " + tf.piece_length);
			System.out.println("SHA-1 Info Hash: " + tf.info_hash_as_url);
			/*
			for (int i = 0; i < tf.piece_hash_values_as_hex.size(); i++)
			{
			  	System.out.println("SHA-1 Hash for Piece ["+ i+ "]: "+ 
				(String) tf.piece_hash_values_as_url.elementAt(i));
			}
			*/
		}
		else
		{
			System.out.println("input tf is null!");
		}
	}
	  
	/**
	 * u stands for unsigned
	 * Converts a two byte array to an integer
	 * @param b a byte array of length 2
	 * @return an int representing the unsigned short
	 */
	public static final int uByteShortToInt(byte[] b)
	{
		int i = 0;
		short usbyte= 0;
		i |= (int) b[0] & 0xFF;
		i <<= 8;
		i |= (int) b[1] & 0xFF;
		return i;
	}
	  
	/**
	 * u stands for unsigned
	 * Converts a four byte array to an integer
	 * @param b a byte array of length 4
	 * @return an int representing the unsigned short
	 */
	public static final int uByteIntToInt(byte[] b)
	{
		int i = 0;
		i |= (long) b[0] & 0xFF;
		i <<= 8;
		i |= (long) b[1] & 0xFF;
		i <<= 8;
		i |= (long) b[2] & 0xFF;
		i <<= 8;
		i |= (long) b[3] & 0xFF;
		return i;
	}
	  
	/**
	 * converts byte[] to URL encoded String
	 * use this function for testing/debugging
	 * author: Hunter Payne
	 */
	public static String byteArrayToURLString(byte in[])
	{
		byte ch = 0x00;
		int i = 0;
		if(in == null || in.length <= 0)
			return null;
		String pseudo[] = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
				"A","B", "C", "D", "E", "F" };
		StringBuffer out = new StringBuffer(in.length * 2);
	      		
		while(i < in.length)
		{	
			// First check to see if we need ASCII or HEX
			if((in[i] >= '0' && in[i] <= '9')
				|| (in[i] >= 'a' && in[i] <= 'z')
				|| (in[i] >= 'A' && in[i] <= 'Z') || in[i] == '$'
				|| in[i] == '-' || in[i] == '_' || in[i] == '.'
				|| in[i] == '+' || in[i] == '!'){
				out.append((char) in[i]);
				i++;
			}	
			else
			{	
				out.append('%');
				ch = (byte) (in[i] & 0xF0); // Strip off high nibble
				ch = (byte) (ch >>> 4); // shift the bits down
				ch = (byte) (ch & 0x0F); // must do this is high order bit is on!
				out.append(pseudo[(int) ch]); // convert the nibble to a
				// String Character
				ch = (byte) (in[i] & 0x0F); // Strip off low nibble
				out.append(pseudo[(int) ch]); // convert the nibble to a
				// String Character
				i++;
			}
		}
	      
		String rslt = new String(out);
		return rslt;
	}
	  
	/** 
	 * Returns a bit-set containing the values in bytes.
	 * The byte-ordermust be bigendian(network order) which means 
	 * the most significant bit is in element 0.
	 */
	public static BitSet fromByteArray(byte[] bytes){
		if(bytes==null){
			return null;
		}
		BitSet bits = new BitSet();
		for (int i=0; i<bytes.length*8; i++) {
			if ((bytes[bytes.length-i/8-1]&(1<<(i%8))) > 0) {
				bits.set(i);
			}	
		}
		return bits;
	}
	  
	/**
	 * printing of elements of byte[]
	 * @param bytes
	 */
	public static void printByteArray(byte[] bytes){
		if(bytes==null)
			return;
		for(int i=0;i<bytes.length;i++){
			System.out.print(bytes[i]);
		}
		System.out.print("\n");
	}
}
