#!/usr/bin/ruby
require 'common.rb'

nodes = {}
sockets = []

server = TCPServer.new("", TRACKER_PORT)
server.setsockopt(Socket::SOL_SOCKET, Socket::SO_REUSEADDR, 1)
sockets << server

puts "Tracker up! Listening for new nodes.."
loop do
	res = select(sockets, nil, nil, 0.5)
	if res != nil
		for sock in res[0]
			if sock == server
				sockets << server.accept
			else
				buf = ""
				begin
					buf = sock.recv(100)
				rescue
				end
				if buf.length == 0
					puts "Tracker: node left @ #{nodes[sock].addr + ":" + nodes[sock].port.to_s}"
					nodes.delete(sock)
					sockets.delete(sock)
					sock.close
				else
					new_node = Node.new(sock.peeraddr[3], buf.to_i)
					puts "Tracker: new node @ #{new_node.addr + ":" + new_node.port.to_s}"
					# notify new node about existing nodes
					nodes.values.each do |n|
						begin
							msg = Marshal.dump(n)
							msg = [msg.length].pack(PACKER) << msg
							sock.send(msg, 0)
						rescue
						end
					end
					# add new node to existing nodes
					nodes[sock] = new_node
				end
			end
		end
	end
end
