package cornell.edu;

public aspect AccountAspect {
    final int MIN_BALANCE = 10;

    pointcut callWithDraw(int amount, Account acc) : 
     call(boolean Account.withdraw(int)) && args(amount) && target(acc);

    before(int amount, Account acc) : callWithDraw(amount, acc) {
     System.out.println("About to withdraw: " + amount + "; balance is: " + acc.balance);
    }

    boolean around(int amount, Account acc) : 
      callWithDraw(amount, acc) {
        if (acc.balance < amount) {
            System.out.println("You cannot withdraw: " + amount + "; balance is: " + acc.balance);
            return false;
        }
        return proceed(amount, acc);
    }

    after(int amount, Account acc) : callWithDraw(amount, acc) {
         System.out.println("Attempted to Withdraw: " + amount + "; balance is: " + acc.balance);
    }
}
