#! /usr/bin/env perl

use strict;
use warnings;

my @NEW_ARGS=();

foreach my $a ( @ARGV ) {
  if ( $a =~ /^-out:(.*)/ ) {
    push @NEW_ARGS, "-out:".xlate_name($1);
  } elsif ( $a =~ /^-/ ) {
    push @NEW_ARGS, $a;
  } else {
    push @NEW_ARGS, xlate_name($a);
  }
}

my $CMD = shift @NEW_ARGS;

system($CMD,@NEW_ARGS);
my $exit_stat = $? >> 8;
exit($exit_stat);

sub xlate_name {
  my ($f) = @_;

  $f =~ s/\//\\/g;

  return $f;
}
