#/*
# * Bernoulli Compiler
# * Copyright (c) Cornell University
# * Department of Computer Science
# * 
# * Kamen Yotov (kamen@yotov.org)
# * 
# * $Source: C:/CVS/kyotov/kyotov/Research/BC/makefile.mak,v $
# * $Revision: 1.6 $
# * $Date: 2003/02/23 15:56:48 $
# */

#!MESSAGE Making $(NAME)...

# .SILENT:

!IF DEFINED(CONFIG)
!IF "$(CONFIG)" == "Debug"
DEBUG = 1
!ENDIF
!ENDIF

!IF !DEFINED(P)
#P = $(MAKEDIR)
P = .
!ENDIF

!IF EXIST($(P)\makefile.mak)
R = $(P)
!ELSE
R = $(P)\..
!ENDIF

!IF !DEFINED(FILTER)
FILTER = $(R)\filter.exe
!ENDIF

!IF !DEFINED(XSD)
XSD = xsd.exe /nologo
!ENDIF

!IF !DEFINED(CSC)
CSC = csc.exe /nologo
!ENDIF

!IF !DEFINED(RESGEN)
RESGEN = resgen.exe
!ENDIF

!IF !DEFINED(MKDIR)
!IF DEFINED(LINUX)
MAKEDIR = mkdir -p
!ELSE
MAKEDIR = mkdir
!ENDIF
!ENDIF

!IF DEFINED(DEBUG)
D = bin\Debug
CSCFlags = /debug:full
!ELSE
D = bin\Release
CSCFlags = /debug- /o+
!ENDIF

!IF !EXIST($(D)\.)
!IF [$(MAKEDIR) $(D)] != 0
!ERROR Cannot create directory '$(D)'!
!ELSE
#!MESSAGE Created directory '$(D)'!
!ENDIF
!ENDIF

.SUFFIXES:
.SUFFIXES: .cs .txt .resx .resources .xsd .dll .exe

.xsd{$(D)}.cs:
	$(XSD) $< /n:$(NS) /c /out:$(@D)

.cs{$(D)}.dll:
	$(CSC) $(CSCFlags) /target:library $<
	
.cs{$(D)}.exe:
	$(CSC) $(CSCFlags) /nologo $<

.txt{$(D)}.resources:
	$(RESGEN) /compile $<,$@
	
.txt{$(D)}.txt:
	copy $< $@
