using System;
using System.IO;
using System.Collections;
using System.CodeDom;
using System.CodeDom.Compiler;
using System.Reflection;

using Microsoft.CSharp;

namespace XTensions.OOCodeDOM
{
	public enum Language
	{
		CSharp
	}

	public class CompileUnit: CodeCompileUnit
	{
		protected static Hashtable CodeDomProviders = new Hashtable();

		static CompileUnit ()
		{
			CodeDomProviders.Add(Language.CSharp, typeof(CSharpCodeProvider));
		}

		public static CompileUnit operator + (CompileUnit cu, CodeNamespace ns)
		{
			cu.Namespaces.Add(ns);

			return cu;
		}

		public string Source (Language l)
		{
			CodeDomProvider p = (CodeDomProvider)(((System.Type)CodeDomProviders[l]).GetConstructor(System.Type.EmptyTypes).Invoke(new object[] {}));

			StringWriter sw = new StringWriter();

			p.CreateGenerator().GenerateCodeFromCompileUnit(this, sw, new CodeGeneratorOptions());

			return sw.ToString();
		}
	}
}