/*
 * String+ Utility
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Utilities/string+/string+.cs,v $
 * $Revision: 1.2 $
 * $Date: 2002/08/14 04:20:09 $
 */

using System;
using System.Diagnostics;

namespace Utilities
{
	class StringPlus
	{
		[STAThread]
		static void Main (string[] a)
		{
			ProcessStartInfo psi = new ProcessStartInfo();
			psi.FileName = "cmd.exe";
			psi.Arguments = "/c " + Environment.CommandLine.Substring(Environment.GetCommandLineArgs()[0].Length + 1);
			psi.UseShellExecute = false;
			psi.RedirectStandardOutput = true;
			psi.CreateNoWindow = true;

			string r = string.Empty;

			foreach (string s in a)
			{
				psi.Arguments = "/c " + s;

				Process p = Process.Start(psi);

				p.WaitForExit();

				r += p.StandardOutput.ReadToEnd();
			}

			Console.Write(r);
		}
	}
}
