/*
 * Time Utility
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Utilities/Time/time.cs,v $
 * $Revision: 1.4 $
 * $Date: 2002/08/22 06:06:54 $
 */

using System;
using System.Diagnostics;

namespace Utilities
{
	class time
	{
		[STAThread]
		static void Main (string[] a)
		{
			//bool silent = a.Length >= 3 && a[2].ToLower() == "/s";

			DateTime dt = DateTime.Now;

			ProcessStartInfo psi = new ProcessStartInfo();
			psi.FileName = a[0];
			psi.Arguments = a[1];

			//psi.UseShellExecute = false;
			//psi.RedirectStandardOutput = true;
			//psi.CreateNoWindow = true;

			psi.WindowStyle = ProcessWindowStyle.Hidden;

			Process p = Process.Start(psi);

			int f = (int)p.ProcessorAffinity;

			p.ProcessorAffinity = (IntPtr)(f & ~(f >> 1));
			p.PriorityClass = ProcessPriorityClass.RealTime;

			p.WaitForExit();

			/*
			if (silent)
				p.WaitForExit();
			else
				while (true)
				{
					string s = p.StandardOutput.ReadLine();

					if (s == null)
						break;

					Console.WriteLine(s);
				}
				*/

			Console.Error.WriteLine("{0:-d.hh:mm:ss:fffffff}", DateTime.Now - dt);
		}
	}
}
