using System;
using System.Diagnostics;
using System.Threading;

namespace MultiRun
{
	class MultiRun
	{
		[STAThread]
		static void Main(string[] a)
		{
			int m = (int)Process.GetCurrentProcess().ProcessorAffinity;
			//int n = 4; //(int)Math.Log(m + 1, 2);
			int n = int.Parse(a[2]);

			Console.WriteLine("{0} processors found!\nRunning {0} copies of {1}...", n, a[0]);

			DateTime dt = DateTime.Now;

			ProcessStartInfo psi = new ProcessStartInfo();
			psi.FileName = a[0];
			psi.Arguments = a[1];

			Process[] p = new Process[n];

			for (int i = 0; i < n; i++)
			{
				p[i] = Process.Start(psi);
				p[i].ProcessorAffinity = (IntPtr)(int.Parse(a[3 + i])); //(IntPtr)((1 << i) & m);
				//Console.WriteLine("Setting affinity of process {0} to {1}", i, (1 << i) & m);
				//p.PriorityClass = ProcessPriorityClass.Normal;
			}

			for (int i = 0; i < n; i++)
			{
				p[i].WaitForExit();
			}

			Console.Error.WriteLine("{0:-d.hh:mm:ss:fffffff}", DateTime.Now - dt);
		}
	}
}
