using System;

namespace Omega
{
	public class VariableTuple
	{
		public delegate int GetVariableDelegate (int index);

		protected GetVariableDelegate d;

		public VariableTuple (GetVariableDelegate d)
		{
			this.d = d;
		}

		public int Count
		{
			get 
			{
				return d(0);
			}
		}

		public Variable this [int i]
		{
			get
			{
				if (i < 1 || i > Count)
					throw new ArgumentOutOfRangeException();

				return new Variable(d(i));
			}
		}

		public static Variable[] Create (params Variable[] x)
		{
			return x;
		}
	}
}
