using System;

namespace Omega.AST
{
	public class Relation: Expression
	{
		protected bool G;
		protected Coefficients L;
		protected Coefficients R;

		public Relation (Coefficients L, Coefficients R, bool G)
		{
			this.L = L;
			this.R = R;
			this.G = G;
		}

		public bool IsGEQ
		{
			get
			{
				return G;
			}
		}

		public Coefficients Coefficients
		{
			get
			{
				return (Coefficients)(L - R);
			}
		}
	}
}
