using System;

namespace Omega.AST
{
	public class Expression: Node
	{
		protected static Coefficient ZERO = new Coefficient(0);

		public static Node TRUE = (ZERO == ZERO);
		public static Node FALSE = !TRUE;
	}

	public class Not: Expression
	{
		protected Expression E;

		public Not (Expression E)
		{
			this.E = E;
		}

		public Expression Expression
		{
			get
			{
				return E;
			}
		}
	}

	public class Binary: Expression
	{
		protected Expression L;
		protected Expression R;

		public Binary (Expression L, Expression R)
		{
			this.L = L;
			this.R = R;
		}

		public Expression Left
		{
			get
			{
				return L;
			}
		}

		public Expression Right
		{
			get
			{
				return R;
			}
		}
	}

	public class And: Binary
	{
		public And (Expression L, Expression R) :
			base(L, R)
		{
		}
	}

	public class Or: Binary
	{
		public Or (Expression L, Expression R) :
			base(L, R)
		{
		}
	}
}
