using System;
using System.Collections;

namespace Omega.AST
{
	public class Coefficients: Node
	{
		protected int C;
		protected Hashtable H;

		public Coefficients ()
		{
			this.C = 0;
			this.H = new Hashtable();
		}

		public Coefficients (Coefficient c) :
			this()
		{
			if (c.IsConstant)
				C = c.Constant;
			else
				H[c.Variable] = c.Constant;
		}

		public int Constant
		{
			get
			{
				return C;
			}
			set
			{
				C = value;
			}
		}

		public int this [Variable v]
		{
			get
			{
				if (H.Contains(v))
					return (int)H[v];
				else
					return 0;
			}
			set
			{
				H[v] = value;
			}
		}

		public ICollection Variables
		{
			get
			{
				return H.Keys;
			}
		}
	}
}
