using System;

namespace Omega.AST
{
	public class Coefficient: Node
	{
		protected int C;
		protected Variable V;

		public Coefficient (int C, Variable V)
		{
			this.C = C;
			this.V = V;
		}

		public Coefficient (int C) :
			this(C, null)
		{
		}

		public Coefficient (Variable V) :
			this(1, V)
		{
		}

		public bool IsConstant
		{
			get
			{
				return (object)V == null;
			}
		}

		public int Constant
		{
			get
			{
				return C;
			}
		}

		public Variable Variable
		{
			get
			{
				if (IsConstant)
					throw new InvalidOperationException();

				return V;
			}
		}
	}
}
