/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/UI.cs,v $
 * $Revision: 1.2 $
 * $Date: 2002/08/15 03:14:12 $
 */

using System;
using System.Resources;

namespace BC.Core
{
	public class UI
	{
		public enum Code
		{
			unknown,
			bc_lexical,
			bc_unpredicted_001,
			bc_syntactic_000,
			bc_syntactic_001,
			bc_syntactic_002,
		}

		public delegate string GetStringDelegate (object o);

		private ResourceManager rm = new ResourceManager("BC.Core.UI", typeof(UI).Assembly);

		private string PrivateGetString (object o)
		{
			return rm.GetString(o.ToString());
		}

		protected GetStringDelegate MemberGetString;

		public GetStringDelegate GetString
		{
			get
			{
				return MemberGetString;
			}
			set
			{
				MemberGetString = value;
			}
		}

		public UI ()
		{
			GetString = new GetStringDelegate(PrivateGetString);
		}
	}
}
