/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Passes/UIDSetter.cs,v $
 * $Revision: 1.3 $
 * $Date: 2002/10/23 05:10:54 $
 */

using System;
using System.IO;
using System.Xml;
using System.Xml.Serialization;

namespace BC.Core
{
	using ASTs;

	namespace Passes
	{
		public class UIDSetter: Walker
		{
			protected int uid = 0;

			public UIDSetter ()
			{
				uid = 0;
			}

			protected override void VisitAbstractNode (AbstractNode n, object o)
			{
				if (n != null)
				{
					n.uidSpecified = true;
					n.uid = ++uid;
				}

				base.VisitAbstractNode(n, o);
			}
		}
	}
}
