using System;

using BC.Core.ASTs;

namespace BC.Core.Passes
{
	public abstract class Renderer: AbstractRenderer
	{
		protected enum Direction
		{
			Left,
			Right
		}

		protected abstract bool OperationNeedsGrouping (AbstractExpression e, AbstractNode p, Direction d);
		protected abstract string Group (string s);

		protected virtual string RenderAbstractExpression (AbstractExpression e, AbstractNode p, Direction d)
		{
			string r = base.RenderAbstractExpression(e);

			if (OperationNeedsGrouping(e, p, d))
				r = Group(r);

			return r;
		}

		protected virtual string RenderAbstractExpression (AbstractExpression e, AbstractNode p)
		{
			return RenderAbstractExpression(e, p, Direction.Left);
		}

		public override string RenderAbstractExpression (AbstractExpression e)
		{
			return RenderAbstractExpression(e, null);
		}
	}
}
