/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Passes/ArrayFixup.cs,v $
 * $Revision: 1.1 $
 * $Date: 2003/02/23 10:08:42 $
 */

using System;
using System.Collections;

namespace BC.Core
{
	using ASTs;

	namespace Passes
	{
		public class ArrayFixup: Walker
		{
			private AbstractExpression Drill (ArrayExpression e, ref ArrayList a)
			{
				AbstractExpression r;

				if (e.Operand is ArrayExpression)
				{
					r = Drill((ArrayExpression)e.Operand, ref a);

					a.AddRange(e.Index);
				}
				else
				{
					r = e.Operand;

					a = new ArrayList(e.Index);
				}

				return r;
			}

			protected override void VisitArrayExpression (ArrayExpression e, object o)
			{
				ArrayList a = null;

				e.Operand = Drill(e, ref a);

				e.Index = (AbstractExpression[])Grammars.Reductions.Common.ListToArray(a, typeof(AbstractExpression));

				base.VisitArrayExpression(e, o);
			}
		}
	}
}