/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Passes/ASTWriter.cs,v $
 * $Revision: 1.2 $
 * $Date: 2002/10/23 05:10:54 $
 */

using System;
using System.IO;
using System.Xml;
using System.Xml.Serialization;

namespace BC.Core
{
	using ASTs;

	namespace Passes
	{
		public class ASTWriter: Pass
		{
			protected string f;

			public ASTWriter (string f)
			{
				this.f = f;
			}

			public override void Execute (ref Elements e, object o)
			{
				XmlSerializer xs = new XmlSerializer(typeof(Elements));
				XmlTextWriter xw = new XmlTextWriter(new StreamWriter(f));
				xw.Formatting = Formatting.Indented;
				xs.Serialize(xw, e);
				xw.Close();
			}
		}
	}
}