/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Machines/VoidType.cs,v $
 * $Revision: 1.6 $
 * $Date: 2002/10/22 19:41:32 $
 */

using System;

namespace BC.Core
{
	namespace Machines
	{
		[Serializable]
		public class VoidType: MachineType
		{
			public VoidType () :
				base(typeof(void))
			{
			}

			public override ASTs.AbstractPrimitiveType ASTType
			{
				get
				{
					return new ASTs.VoidType();
				}
			}

			public override int Precision
			{
				get
				{
					return 0;
				}
			}

			public static VoidType TheVoidType = new VoidType();
		}
	}
}