/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Machines/MachineType.cs,v $
 * $Revision: 1.5 $
 * $Date: 2002/10/22 19:41:32 $
 */

using System;

namespace BC.Core
{
	using ASTs;

	namespace Machines
	{
		[Serializable]
		public abstract class MachineType
		{
			public MachineType (Type t)
			{
				this.t = t;
			}

			public Type Type
			{
				get
				{
					return t;
				}
			}

			public string Name
			{
				get
				{
					return t.Name;
				}
			}

			protected Type t;

			public abstract AbstractPrimitiveType ASTType
			{
				get;
			}

			public abstract int Precision
			{
				get;
			}
		}
	}
}