/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Machines/ComplexType.cs,v $
 * $Revision: 1.5 $
 * $Date: 2002/10/22 19:41:32 $
 */

using System;

namespace BC.Core
{
	namespace Machines
	{
		[Serializable]
		public class ComplexType: RealType
		{
			public ComplexType (Type t) :
				base(t)
			{
			}

			public override ASTs.AbstractPrimitiveType ASTType
			{
				get
				{
					ASTs.ComplexType t = new ASTs.ComplexType();

					t.Precision = Precision;

					return t;
				}
			}

			new public static ComplexType Get (int p)
			{
				return new ComplexType(RealType.Get(p).Type);
			}
		}
	}
}