/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Machines/BoolType.cs,v $
 * $Revision: 1.7 $
 * $Date: 2002/10/22 19:41:32 $
 */

using System;

namespace BC.Core
{
	namespace Machines
	{
		[Serializable]
		public class BoolType: MachineType
		{
			public BoolType () :
				base(typeof(bool))
			{
			}

			public override ASTs.AbstractPrimitiveType ASTType
			{
				get
				{
					return new ASTs.BoolType();
				}
			}

			public override int Precision
			{
				get
				{
					return new IntegerType().Precision;
				}
			}

			public static BoolType TheBoolType = new BoolType();
		}
	}
}