/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Lexers/Source.cs,v $
 * $Revision: 1.5 $
 * $Date: 2002/07/22 23:34:47 $
 */

using System;
using System.IO;
using System.Collections;

namespace BC.Core
{
	namespace Lexers
	{
		public class Source
		{
			protected string f;
			protected string c;
			protected ArrayList l;

			public Source (string f)
			{
				this.f = f;

				c = new StreamReader(f).ReadToEnd();

				l = new ArrayList();
				l.Add(0);

				for (int i = 0; i < c.Length; i++)
				{
					if (c[i] == '\n')
					{
						if (i < c.Length && i == '\r')
							i++;

						l.Add(i + 1);
					}
				}

				l.Add(c.Length);
			}

			public string Content
			{
				get
				{
					return c;
				}
			}

			public string Name
			{
				get
				{
					return f;
				}
			}

			public Location this [int p, int _c]
			{
				get
				{
					return new Location(Name, c, l, p, _c);
				}
			}
		}
	}
}