/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Lexers/Packet.cs,v $
 * $Revision: 1.4 $
 * $Date: 2002/07/22 21:06:28 $
 */

using System;
using System.Collections;

namespace BC.Core
{
	namespace Lexers
	{
		[Serializable]
		public sealed class Packet
		{
			private string name;
			private string pattern;
			private IDictionary children;
			private IList names;
			private Packet parent;

			public Packet (string name, string pattern)
			{
				this.name = name;
				this.pattern = pattern;
			
				parent = null;

				children = new Hashtable();
				names = new ArrayList();
			}

			public Packet (string name) :
				this(name, null)
			{
			}

			public string Name
			{
				get
				{
					return name;
				}
			}

			public string FullName
			{
				get
				{
					return Parent == null ? "" : string.Format("{0}_{1}", Parent.FullName, Name);
				}
			}

			public string Pattern
			{
				get
				{
					return pattern;
				}
				set
				{
					pattern = value;
				}
			}

			public IDictionary Children
			{
				get
				{
					return children;
				}
			}

			public IList Names
			{
				get
				{
					return names;
				}
			}

			public Packet this [string child]
			{
				get
				{
					return (Packet)children[child];
				}
				set
				{
					if (!names.Contains(child))
						names.Add(child);

					children[child] = value;
					value.parent = this;
				}
			}

			public Packet Parent
			{
				get
				{
					return parent;
				}
			}
		}
	}
}