/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Grammars/Symbols/VirtualSymbol.cs,v $
 * $Revision: 1.6 $
 * $Date: 2002/12/05 03:07:54 $
 */

using System;

namespace BC.Core
{
	namespace Grammars
	{
		namespace Symbols
		{
			public class VirtualSymbol: Symbol
			{
				protected Sequence s;

				public VirtualSymbol (Sequence s)
				{
					this.s = s;
				}

				public Sequence Sequence
				{
					get
					{
						return s;
					}
				}

				public override object Result
				{
					get
					{
						return this;
					}
					set
					{
					}
				}

				public override string Format (string f)
				{
					return string.Format("O({0})", s.ToString());
				}
			}
		}
	}
}