/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Grammars/Symbols/Terminal.cs,v $
 * $Revision: 1.9 $
 * $Date: 2003/01/06 07:03:29 $
 */

using System;

namespace BC.Core
{
	using Lexers;

	namespace Grammars
	{
		namespace Symbols
		{
			[Serializable]
			public class Terminal: PhysicalSymbol, IComparable
			{
				protected string v;

				public Terminal (string s, string v, Location l) :
					base(s, l)
				{
					this.v = v;
				}

				public Terminal (string s, string v) :
					this(s, v, null)
				{
				}

				public Terminal (string s) :
					this(s, null)
				{
				}

				public string Value
				{
					get
					{
						return v;
					}
				}

				public bool IsA (Terminal t)
				{
					if (t == null)
						return false;

					string[] s1 = Name.Split('_');
					string[] s2 = t.Name.Split('_');

					for (int i = 0; i < Math.Min(s1.Length, s2.Length); i++)
						if (s1[i] != s2[i])
							return false;

					return true;

					//return t != null && this.Name.Substring(0, Math.Min(this.Name.Length, t.Name.Length)) == t.Name;
				}

				public bool IsA (string n)
				{
					return IsA(new Terminal(n));
				}

				public override object Result 
				{
					get
					{
						return this;
					}
					set
					{
					}
				}

				public override string Format (string f)
				{
					if (Value != null)
						return string.Format("\"{0}\"", Value);
					else
						return string.Format("{1}{0}{1}", s, f == null ? "" : f);
				}

				public int CompareTo (object o)
				{
					return Location.Position - ((Terminal)o).Location.Position;
				}
			}
		}
	}
}