/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Grammars/Symbols/PhisicalSymbol.cs,v $
 * $Revision: 1.5 $
 * $Date: 2002/07/22 23:34:47 $
 */

using System;

namespace BC.Core
{
	using Lexers;
	using Automatas;

	namespace Grammars
	{
		namespace Symbols
		{
			[Serializable]
			public abstract class PhysicalSymbol: Symbol
			{
				protected string s;
				protected Node n;
				[NonSerialized]
				protected Location l;

				public PhysicalSymbol (string s, Location l)
				{
					this.s = s;
					this.l = l;
				}

				public override bool Equals (object o)
				{
					return this.GetType() == o.GetType() && s == ((PhysicalSymbol)o).s;
				}

				public override int GetHashCode ()
				{
					return s.GetHashCode();
				}

				public override Node Node
				{
					get
					{
						return n;
					}
					set
					{
						n = value;
					}
				}

				public string Name
				{
					get
					{
						return s;
					}
				}

				public Location Location
				{
					get
					{
						return l;
					}
					set
					{
						l = value;
					}
				}
			}
		}
	}
}