/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Grammars/Symbols/NonTerminal.cs,v $
 * $Revision: 1.6 $
 * $Date: 2002/07/26 19:10:57 $
 */

using System;

namespace BC.Core
{
	using Lexers;

	namespace Grammars
	{
		namespace Symbols
		{
			[Serializable]
			public class NonTerminal: PhysicalSymbol
			{
				[NonSerialized]
				protected object r;

				public NonTerminal (string s, Location l, object r) :
					base(s, l)
				{
					this.r = r;
				}

				public NonTerminal (string s, Location l) :
					this(s, null, null)
				{
				}

				public NonTerminal (string s, object o) :
					this(s, null, o)
				{
				}

				public NonTerminal (string s) :
					this(s, null)
				{
				}

				public override object Result
				{
					get
					{
						return r;
					}
					set
					{
						r = value;
					}
				}

				public override string Format (string f)
				{
					return s;
				}
			}
		}
	}
}