/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Grammars/Rule.cs,v $
 * $Revision: 1.4 $
 * $Date: 2002/07/22 21:06:27 $
 */

using System;

namespace BC.Core
{
	namespace Grammars
	{
		using Symbols;

		[Serializable]
		public class Rule
		{
			protected NonTerminal lhs;
			protected Alternatives rhs;

			public Rule (NonTerminal lhs, Alternatives rhs)
			{
				this.lhs = lhs;
				this.rhs = rhs;
			}

			public NonTerminal LHS
			{
				get
				{
					return lhs;
				}
			}

			public Alternatives RHS
			{
				get
				{
					return rhs;
				}
			}
	
			public override bool Equals (object o)
			{
				Rule r = (Rule)o;

				return LHS.Equals(r.LHS) && RHS.Equals(r.RHS);
			}

			public override int GetHashCode ()
			{
				return LHS.GetHashCode() ^ RHS.GetHashCode();
			}
		}
	}
}