/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Grammars/Reductions/Translation.cs,v $
 * $Revision: 1.4 $
 * $Date: 2002/07/22 21:06:28 $
 */

using System;
using System.Collections;

namespace BC.Core
{
	namespace Grammars
	{
		namespace Reductions
		{
			[Serializable]
			public class Translation
			{
				public Translation (Reduction r, int[] x)
				{
					this.r = r;
					this.x = x;
				}

				public object Execute (object[] _)
				{
					object[] o = new object[x.Length];

					for (int i = 0; i < x.Length; i++)
						if (x[i] >= 0)
							o[i] = _[x[i]];

					return r(o);
				}

				protected Reduction r;
				protected int[] x;
			}
		}
	}
}