/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Grammars/Reductions/Common.cs,v $
 * $Revision: 1.5 $
 * $Date: 2002/08/09 02:35:53 $
 */

using System;
using System.Collections;

namespace BC.Core
{
	namespace Grammars
	{
		namespace Reductions
		{
			public class Common
			{
				public static object CreateList (object[] o)
				{
					ArrayList a = new ArrayList();

					a.Add(o[0]);

					return a;
				}

				public static object AddToList (object[] o)
				{
					ArrayList a = (ArrayList)o[0];

					a.Add(o[1]);

					return a;
				}

				public static object MergeLists (object[] o)
				{
					ArrayList a = (ArrayList)o[0];

					a.AddRange((ArrayList)o[1]);

					return a;
				}

				public static object ShortCut (object[] o)
				{
					return o[0];
				}

				public static readonly Reduction RCreateList = new Reduction(CreateList);
				public static readonly Reduction RAddToList = new Reduction(AddToList);
				public static readonly Reduction RMergeLists = new Reduction(MergeLists);
				public static readonly Reduction RShortCut = new Reduction(ShortCut);

				public static Array ListToArray (ArrayList l, Type t)
				{
					Array a = Array.CreateInstance(t, l.Count);

					l.CopyTo(a);

					return a;
				}

				public static ArrayList ObjectToList (object o)
				{
					return o == null ? new ArrayList() : (ArrayList)o;
				}

				public static Array ObjectToArray (object o, Type t)
				{
					return ListToArray(ObjectToList(o), t);
				}
			}
		}
	}
}