/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Grammars/Production.cs,v $
 * $Revision: 1.4 $
 * $Date: 2002/07/22 21:06:27 $
 */

using System;

namespace BC.Core
{
	namespace Grammars
	{
		using Symbols;

		[Serializable]
		public class Production
		{
			protected NonTerminal lhs;
			protected Alternative rhs;

			public Production (NonTerminal lhs, Alternative rhs)
			{
				this.lhs = lhs;
				this.rhs = rhs;
			}

			public NonTerminal LHS
			{
				get
				{
					return lhs;
				}
			}

			public Alternative RHS
			{
				get
				{
					return rhs;
				}
			}

			public override bool Equals (object o)
			{
				Production p = (Production)o;

				return LHS.Equals(p.LHS) && RHS.Equals(p.RHS);
			}

			public override int GetHashCode ()
			{
				return LHS.GetHashCode() ^ RHS.GetHashCode();
			}

			public override string ToString ()
			{
				return string.Format("{0} ->{1}", LHS, RHS);
			}
		}
	}
}