/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Grammars/Alternatives.cs,v $
 * $Revision: 1.4 $
 * $Date: 2002/07/22 21:06:27 $
 */

using System;
using System.Collections;

namespace BC.Core
{
	namespace Grammars
	{
		[Serializable]
		public class Alternatives: ArrayList, IEnumerable
		{
			public new Alternative this [int i]
			{
				get
				{
					return (Alternative)base[i];
				}
			}

			public override bool Equals (object o)
			{
				Alternatives s = (Alternatives)o;

				if (Count == s.Count)
				{
					for (int i = 0; i < Count; i++)
						if (!this[i].Equals(s[i]))
							return false;

					return true;
				}

				return false;
			}

			public override int GetHashCode ()
			{
				int r = 0;

				foreach (Alternative a in this)
					r ^= a.GetHashCode();

				return r;
			}

			public static Alternatives operator | (Alternatives s, Alternative a)
			{
				Alternatives n = new Alternatives();

				n.AddRange(s);
				n.Add(a);

				return n;
			}
		}
	}
}