/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Grammars/Alternative.cs,v $
 * $Revision: 1.4 $
 * $Date: 2002/07/22 21:06:27 $
 */

using System;
using System.Collections;

namespace BC.Core
{
	namespace Grammars
	{
		using Symbols;
		using Reductions;

		[Serializable]
		public class Alternative
		{
			protected Sequence s;
			protected Reduction r;

			public Alternative (Sequence s)
			{
				this.s = s;
			}

			public Alternative () :
				this(new Sequence())
			{
			}

			public Sequence Sequence
			{
				get
				{
					return s;
				}
			}

			public Reduction Reduction
			{
				get
				{
					return r;
				}
				set
				{
					r = value;
				}
			}

			public static Alternatives operator | (Alternative a1, Alternative a2)
			{
				Alternatives s = new Alternatives();

				s.Add(a1);
				s.Add(a2);

				return s;
			}

			public static implicit operator Alternatives (Alternative a)
			{
				Alternatives s = new Alternatives();

				s.Add(a);

				return s;
			}

			public override string ToString ()
			{
				string r = "";

				if (Sequence.Count > 0)
					foreach (Symbol s in Sequence)
						r += string.Format(" {0:\"}", s);
				else
					r += new Epsilon();

				return r;
			}
		}
	}
}