/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Exceptions/SyntacticException.cs,v $
 * $Revision: 1.6 $
 * $Date: 2002/08/15 17:36:10 $
 */

using System;
using System.IO;
using System.Collections;

namespace BC.Core.Exceptions
{
	using Lexers;
	using Grammars;

	public class SyntacticException: BCException
	{
		public SyntacticException (object c, Location l, Sequence x) :
			base(ExceptionType.Syntactic, c, l)
		{
			this.x = x;
		}

		protected Sequence x;

		public override string ToString ()
		{
			return string.Format("{1}\nState: {0}", x, base.ToString());
		}
	}
}
