/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Exceptions/CompositeException.cs,v $
 * $Revision: 1.1 $
 * $Date: 2002/08/15 17:36:10 $
 */

using System;
using System.IO;
using System.Collections;

namespace BC.Core.Exceptions
{
	using Lexers;
	using Grammars;

	public class CompositeException: SyntacticException
	{
		public CompositeException (object c, Location l, Sequence x, ICollection e) :
			base(c, l, x)
		{
			exceptions = e;
		}

		protected ICollection exceptions;

		public override string ToString ()
		{
			StringWriter w = new StringWriter();

			w.WriteLine(base.ToString());

			foreach (Exception e in exceptions)
				w.Write(Global.Indent(e.ToString(), 1));

			return w.ToString();
		}
	}
}
