/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Exceptions/BCException.cs,v $
 * $Revision: 1.3 $
 * $Date: 2002/08/15 17:36:10 $
 */

using System;
using System.Resources;

namespace BC.Core
{
	using Lexers;

	namespace Exceptions
	{
		public enum ExceptionType
		{
			Lexical,
			Syntactic,
			Semantic,
			Unpredicted
		}
	
		public class BCException: System.Exception
		{
			protected ExceptionType t;
			protected object c;
			protected Location l;
			protected object[] p;

			public BCException (ExceptionType t, object c, Location l, params object[] p) : 
				base(t.ToString())
			{
				this.t = t;
				this.c = c;
				this.l = l;
				this.p = p != null ? p : new object[1];
			}

			public BCException (ExceptionType t, object c, Location l) : 
				this(t, c, l, null)
			{
			}

			public BCException (ExceptionType t, object c, params object[] p) :
				this(t, c, null, p)
			{
			}

			public BCException (ExceptionType t, object c) :
				this(t, c, null, null)
			{
			}

			public BCException (ExceptionType t, Location l) :
				this(t, UI.Code.unknown, l)
			{
			}

			public BCException (ExceptionType t) :
				this(t, UI.Code.unknown, null, null)
			{
			}

			public BCException (Location l) :
				this(ExceptionType.Unpredicted, l)
			{
			}

			public BCException () :
				this(null)
			{
			}

			public Location Location
			{
				get
				{
					return l;
				}
				set
				{
					l = value;
				}
			}

			public ExceptionType Type
			{
				get
				{
					return t;
				}
			}

			public object Code
			{
				get
				{
					return c;
				}
			}

			public override string ToString ()
			{
				return string.Format("{0} Error: {1}!\n{2}", Message, string.Format(Global.GetString(c.ToString()), p), l);
			}
		}
	}
}