/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/Automatas/Node.cs,v $
 * $Revision: 1.5 $
 * $Date: 2002/10/22 19:50:41 $
 */

using System;
using System.Collections;
using System.Diagnostics;

using XTensions.Collections;

namespace BC.Core
{
	using Grammars;
	using Grammars.Symbols;
	using Exceptions;

	namespace Automatas
	{
		[Serializable]
		public class Node
		{
			protected Set items;
			protected IDictionary edges;

			public Node ()
			{
				items = new Set();
				edges = new Hashtable();
			}

			public Node (Item i):
				this()
			{
				items.Add(i);
			}

			public Node (Set r, Set e) :
				this()
			{
				foreach (Node n in r)
					Items += n.Items;

				foreach (Symbol s in e)
					this[s] = new Set();
			}

			public ICollection Edges
			{
				get
				{
					return edges.Keys;
				}
			}

			public bool HasEdge (Symbol s)
			{
				return edges.Contains(s);
			}

			public Set Items
			{
				get
				{
					return items;
				}
				set
				{
					items = value;
				}
			}

			public Item Singleton
			{
				get
				{
					Debug.Assert(Items.Count <= 1);

					foreach (Item i in Items)
						return i;

					return null;
				}
			}

			public Set this [Symbol name]
			{
				get
				{
					Set e = (Set)edges[name];

					if (Set.isNull(e))
						edges[name] = e = new Set();

					return e;
				}
				set
				{
					edges[name] = value;
				}
			}

			public override string ToString ()
			{
				string r = "Node {\n";

				foreach (Item i in Items)
					r += string.Format("\t{0}\n", i);

				r += "Edges:\n\t";

				foreach (Symbol s in Edges)
					r += string.Format("{0} ", s);

				return string.Format("{0}\n}}\n", r);
			}
		}
	}
}